<%@ Import Namespace="System.Web.Services" %>
<%@ Import Namespace="AjaxControlToolkit" %>
<%@ Register Assembly="AjaxControlToolkit"
    Namespace="AjaxControlToolkit" TagPrefix="asp" %>

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">

   <script runat="server" language="vb">

      <WebMethod, System.Web.Script.Services.ScriptMethod> _
       Public Shared Function GetStates(ByVal _
        knownCategoryValues As String, _
        ByVal category As String) As Object()

        Return New Object() { New _
          CascadingDropDownNameValue("Maopolskie", "Maopolskie"), _
          New CascadingDropDownNameValue("Mazowieckie", "Mazowieckie") }
     End Function

    <WebMethod, System.Web.Script.Services.ScriptMethod > _
     Public Shared Function GetCounties(ByVal _
       knownCategoryValues As String, _
       ByVal category As String) As Object()

        If knownCategoryValues.Contains("Maopolskie") Then
           Return New Object() { New _
              CascadingDropDownNameValue("Krakw", _
               "Krakw"), _
              New CascadingDropDownNameValue("Nowy Targ", _
               "Nowy Targ"), _
              New CascadingDropDownNameValue("Wadowice", _
               "Wadowice"), _
              New CascadingDropDownNameValue("Zakopane", "Zakopane"), _
              New CascadingDropDownNameValue("Owicim", "Owicim") }
         End If

         If knownCategoryValues.Contains("Mazowieckie") Then
            Return New Object() { New _
               CascadingDropDownNameValue("Warszawa", "Warszawa"), _
               New CascadingDropDownNameValue("Ostroka", "Ostroka"), _
               New CascadingDropDownNameValue("Pock", "Pock"),
               New CascadingDropDownNameValue("Radom", "Radom"), _
               New CascadingDropDownNameValue("Siedlce", "Siedlce") }
         End If

         Return Nothing
      End Function

</script>

<title>CascadingDropDown</title>
</head>
<body>
   <form id="form1" runat="server">
   <asp:ToolkitScriptManager runat="server" ID="scriptManager" />
   <div>
      <asp:DropDownList runat="server" ID="ddl1" Width="200" />
      <br />
      <asp:DropDownList runat="server" ID="ddl2" Width="200" />
      <br />
      <asp:CascadingDropDown runat="server" ID="cdd1"
         TargetControlID="ddl1"
         PromptText="Wybierz wojewdztwo"
         Category="state" LoadingText="[Wczytywanie wojewdztw]"
         ServiceMethod="GetStates" />
      <asp:CascadingDropDown runat="server" ID="cdd2"
         TargetControlID="ddl2"
         ParentControlID="ddl1"
         PromptText="Wybierz powiat" Category="county"
         LoadingText="[Wczytywanie powiatw]"
         ServiceMethod="GetCounties" />
   </div>
   </form>
</body>
</html>
